#ifndef _ScanDialog_CPP
#define _ScanDialog_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <WinSock.H>
#include <Windows.H>
#include <WindowsX.H>
#include <ShlOBJ.H>
#include <CommCtrl.H>
#include <StdIO.H>
#include <IO.H>
#include <IPHlpAPI.h>

#include "../Resources/Resource.H"

#include "../Source/NSWFL.H"
#include "../Source/Debug.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/ScanDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND hScanDialog = NULL;
HWND hStatusText = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ScanDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    static HWND ANIPlaceHolder_hWnd = NULL;
    static HWND StaticText_hWnd = NULL;
    
    static HFONT LinksFontHandle    = NULL;

    static DWORD RGBStatic, SystemBGColor;

	//--------------------------------------------------------------------------

    if(uMsg == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
		hScanDialog = hWnd;

        HMENU SystemMenu_hMenu = GetSystemMenu(hWnd, FALSE);
        AppendMenu(SystemMenu_hMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu_hMenu, MF_STRING, MAINDIALOG_MENU_ABOUT, "About");

        SendMessage(hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(hWnd, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)));

        ANIPlaceHolder_hWnd = GetDlgItem(hWnd, IDC_ANIPLACEHOLDER);
        StaticText_hWnd = GetDlgItem(hWnd, IDC_STATICTEXT);
        hStatusText = GetDlgItem(hWnd, IDC_STATUSTEXT);

        HCURSOR IconHandle = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDR_WORKINGANI));
        SendMessage(ANIPlaceHolder_hWnd, (UINT)STM_SETIMAGE, (WPARAM)IMAGE_ICON, (LPARAM)IconHandle);

        LinksFontHandle = MakeFont("MS Sans Serif", 14);

        SetFont(StaticText_hWnd, LinksFontHandle);

        RGBStatic = RGB(128, 0, 128);
        SystemBGColor = GetSysColor(COLOR_3DFACE);
		
		hPOPGrid_Thread = CreateThread(NULL, 0, POPGrid_Thread, (LPVOID)0, 0, &dwPOPGrid_Thread_ID);

		CenterWindow(hWnd);

		return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE.
    }

	//--------------------------------------------------------------------------

	if(uMsg == WM_CTLCOLORSTATIC)
    {
        if((HANDLE)lParam == StaticText_hWnd)
		{
            return Set_Color(RGBStatic, SystemBGColor, wParam);
		}
    }

	//--------------------------------------------------------------------------

	if(uMsg == WM_COMMAND) // Received a message
    {
        if(wParam == IDC_CANCELBUTTON)
        {
            SuspendThread(hPOPGrid_Thread);
            TerminateThread(hPOPGrid_Thread, 0);
            CloseHandle(hPOPGrid_Thread);
            EndDialog(hWnd, 1);

			hScanDialog = NULL;
		}
        return TRUE;
    }

	//--------------------------------------------------------------------------

	if(uMsg == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(hWnd, &ThisPS);

        //- Any painting should be done here.

        EndPaint(hWnd, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_SYSCOMMAND) //- Received a system menu message.
    {
        if(LOWORD(wParam) == MAINDIALOG_MENU_ABOUT) //- About.
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = hWnd;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_CLOSE) //- Received close message.
    {
        EndDialog(hWnd,0);
        DestroyWindow(hWnd);

		hScanDialog = NULL;

        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

